/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SarkhansScornWatcher
extends Watcher {
    private final Map<UUID, Set<Integer>> playerMap = new HashMap<UUID, Set<Integer>>();
    private static final Set<Integer> emptySet = Collections.unmodifiableSet(new HashSet());

    SarkhansScornWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.BEGINNING_PHASE_PRE) {
            return;
        }
        if (game.getTurnNum() == 1) {
            this.playerMap.clear();
        }
        this.playerMap.computeIfAbsent(game.getActivePlayerId(), x -> new HashSet()).add(game.getTurnNum());
    }

    static int getCount(UUID playerId, Game game) {
        return ((SarkhansScornWatcher)game.getState().getWatcher(SarkhansScornWatcher.class)).playerMap.getOrDefault(playerId, emptySet).size();
    }
}

