/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.CamaridToken;
import mage.game.permanent.token.CitizenToken;
import mage.game.permanent.token.GoblinToken;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.ThrullToken;

class SarpadianEmpiresCreateSelectedTokenEffect
extends OneShotEffect {
    SarpadianEmpiresCreateSelectedTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 1/1 creature token of the chosen color and type";
    }

    private SarpadianEmpiresCreateSelectedTokenEffect(SarpadianEmpiresCreateSelectedTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public SarpadianEmpiresCreateSelectedTokenEffect copy() {
        return new SarpadianEmpiresCreateSelectedTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CitizenToken token;
        String tokenType;
        switch (tokenType = game.getState().getValue(source.getSourceId().toString() + "_SarpadianEmpiresVolVii").toString()) {
            case "White Citizen": {
                token = new CitizenToken();
                break;
            }
            case "Blue Camarid": {
                token = new CamaridToken();
                break;
            }
            case "Black Thrull": {
                token = new ThrullToken();
                break;
            }
            case "Red Goblin": {
                token = new GoblinToken();
                break;
            }
            default: {
                token = new SaprolingToken();
            }
        }
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        return true;
    }
}

