/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetCardCopyAndCastEffect;
import mage.cards.s.SarumanOfManyColors;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;

class SarumanOfManyColorsEffect
extends OneShotEffect {
    SarumanOfManyColorsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "each opponent mills two cards. When one or more cards are milled this way, exile target enchantment, instant, or sorcery card with equal or lesser mana value than that spell from an opponent's graveyard. Copy the exiled card. You may cast the copy without paying its mana cost.";
    }

    private SarumanOfManyColorsEffect(SarumanOfManyColorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean trigger_second_part = false;
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            trigger_second_part |= !player.millCards(2, source, game).isEmpty();
        }
        if (!trigger_second_part) {
            return true;
        }
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        FilterCard filter = new FilterCard("enchantment, instant, or sorcery card with equal or lesser mana value than that spell from an opponent's graveyard");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, spell.getManaValue() + 1));
        filter.add(SarumanOfManyColors.predicate);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ExileTargetCardCopyAndCastEffect(true), false, "When one or more cards are milled this way, exile target enchantment, instant, or sorcery card with equal or lesser mana value than that spell from an opponent's graveyard.Copy the exiled card. You may cast the copy without paying its mana cost.");
        ability.addTarget((Target)new TargetCardInOpponentsGraveyard(filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    public SarumanOfManyColorsEffect copy() {
        return new SarumanOfManyColorsEffect(this);
    }
}

