/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class SauronsRansomEffect
extends OneShotEffect {
    SauronsRansomEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose an opponent. They look at the top four cards of your library and separate them into a face-down pile and a face-up pile. Put one pile into your hand and the other into your graveyard";
    }

    private SauronsRansomEffect(SauronsRansomEffect effect) {
        super((OneShotEffect)effect);
    }

    public SauronsRansomEffect copy() {
        return new SauronsRansomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent targetOpponent = new TargetOpponent(true);
        targetOpponent.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 4));
        TargetCard targetFaceDownPile = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, new FilterCard("cards for the face-down pile"));
        opponent.choose(this.outcome, (Cards)cards, targetFaceDownPile, source, game);
        CardsImpl faceDownPile = new CardsImpl((Collection)targetFaceDownPile.getTargets());
        cards.removeAll((Collection)targetFaceDownPile.getTargets());
        controller.revealCards(sourceObject.getIdName() + " - cards in face-up pile", (Cards)cards, game);
        game.informPlayers(opponent.getLogName() + " puts " + faceDownPile.size() + " card(s) into the face-down pile");
        boolean pileChosen = controller.chooseUse(this.outcome, "Choose a pile to put in your hand.", null, "Face-down", "Face-up", source, game);
        if (pileChosen) {
            controller.moveCards((Cards)faceDownPile, Zone.HAND, source, game);
            controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        } else {
            controller.moveCards((Cards)faceDownPile, Zone.GRAVEYARD, source, game);
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        return true;
    }
}

