/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SavageSummoningWatcher
extends Watcher {
    private Set<String> savageSummoningSpells = new HashSet<String>();
    private Map<UUID, Set<String>> spellsCastWithSavageSummoning = new LinkedHashMap<UUID, Set<String>>();
    private Map<String, Set<String>> cardsCastWithSavageSummoning = new LinkedHashMap<String, Set<String>>();

    public SavageSummoningWatcher() {
        super(WatcherScope.PLAYER);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && this.isSavageSummoningSpellActive() && event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isCreature(game)) {
            this.spellsCastWithSavageSummoning.put(spell.getId(), new HashSet<String>(this.savageSummoningSpells));
            String cardKey = spell.getCard().getId().toString() + '_' + spell.getCard().getZoneChangeCounter(game);
            this.cardsCastWithSavageSummoning.put(cardKey, new HashSet<String>(this.savageSummoningSpells));
            this.savageSummoningSpells.clear();
        }
    }

    public void setSavageSummoningSpellActive(Card card, Game game) {
        String cardKey = card.getId().toString() + '_' + card.getZoneChangeCounter(game);
        this.savageSummoningSpells.add(cardKey);
    }

    public boolean isSavageSummoningSpellActive() {
        return !this.savageSummoningSpells.isEmpty();
    }

    public boolean isSpellCastWithThisSavageSummoning(UUID spellId, UUID cardId, int zoneChangeCounter) {
        String cardKey = cardId.toString() + '_' + zoneChangeCounter;
        Set<String> savageSpells = this.spellsCastWithSavageSummoning.get(spellId);
        return savageSpells != null && savageSpells.contains(cardKey);
    }

    public boolean isCardCastWithThisSavageSummoning(Card card, UUID cardId, int zoneChangeCounter, Game game) {
        String creatureCardKey = card.getId().toString() + '_' + card.getZoneChangeCounter(game);
        String cardKey = cardId.toString() + '_' + zoneChangeCounter;
        Set<String> savageSpells = this.cardsCastWithSavageSummoning.get(creatureCardKey);
        return savageSpells != null && savageSpells.contains(cardKey);
    }

    public void reset() {
        super.reset();
        this.savageSummoningSpells.clear();
        this.spellsCastWithSavageSummoning.clear();
        this.cardsCastWithSavageSummoning.clear();
    }
}

