/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SavingGraceReplacementEffect
extends ReplacementEffectImpl {
    SavingGraceReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "all damage that would be dealt this turn to you and permanents you control is dealt to enchanted creature instead.";
    }

    private SavingGraceReplacementEffect(SavingGraceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent targetPermanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER) {
            return event.getPlayerId().equals(source.getControllerId());
        }
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (targetPermanent = game.getPermanent(event.getTargetId())) != null && targetPermanent.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            Permanent creature = game.getPermanent(sourcePermanent.getAttachedTo());
            if (creature == null) {
                return false;
            }
            Permanent targetPermanent = game.getPermanent(event.getTargetId());
            StringBuilder message = new StringBuilder();
            message.append(creature.getName()).append(": gets ");
            message.append(damageEvent.getAmount()).append(" damage redirected from ");
            if (targetPermanent != null) {
                message.append(targetPermanent.getName());
            } else {
                Player targetPlayer = game.getPlayer(event.getTargetId());
                if (targetPlayer != null) {
                    message.append(targetPlayer.getLogName());
                } else {
                    message.append("unknown");
                }
            }
            game.informPlayers(message.toString());
            creature.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
            return true;
        }
        return false;
    }

    public SavingGraceReplacementEffect copy() {
        return new SavingGraceReplacementEffect(this);
    }
}

