/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SavvyTraderEffect
extends OneShotEffect {
    SavvyTraderEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile target permanent card from your graveyard. You may play that card for as long as it remains exiled";
    }

    private SavvyTraderEffect(SavvyTraderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SavvyTraderEffect copy() {
        return new SavvyTraderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String exileName;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Card card = game.getCard(source.getFirstTarget());
        if (sourcePermanent == null || controller == null || card == null) {
            return false;
        }
        String keyForPlayer = "Shared::EndOfGame::PlayerMayPlay=" + controller.getId();
        UUID exileId = CardUtil.getExileZoneId((String)keyForPlayer, (Game)game);
        if (controller.moveCardsToExile(card, source, game, true, exileId, exileName = controller.getName() + " may play for as long as cards remains exiled")) {
            PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Duration.EndOfGame);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

