/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;

class ScapeshiftEffect
extends OneShotEffect {
    ScapeshiftEffect() {
        super(Outcome.Neutral);
        this.staticText = "Sacrifice any number of lands. Search your library for up to that many land cards, put them onto the battlefield tapped, then shuffle";
    }

    private ScapeshiftEffect(ScapeshiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScapeshiftEffect copy() {
        return new ScapeshiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInLibrary target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = 0;
        TargetSacrifice sacrificeLand = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_LANDS);
        if (controller.choose(Outcome.Sacrifice, (Target)sacrificeLand, source, game)) {
            for (UUID uuid : sacrificeLand.getTargets()) {
                Permanent land = game.getPermanent(uuid);
                if (land == null) continue;
                land.sacrifice(source, game);
                ++amount;
            }
        }
        if (controller.searchLibrary(target = new TargetCardInLibrary(amount, (FilterCard)new FilterLandCard("lands")), source, game)) {
            controller.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

