/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScarabOfTheUnseenEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public ScarabOfTheUnseenEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all Auras attached to target permanent you own to their owners' hands";
    }

    private ScarabOfTheUnseenEffect(ScarabOfTheUnseenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScarabOfTheUnseenEffect copy() {
        return new ScarabOfTheUnseenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (controller != null && targetPermanent != null) {
            if (!targetPermanent.getAttachments().isEmpty()) {
                ArrayList attachments = new ArrayList();
                attachments.addAll(targetPermanent.getAttachments());
                for (UUID attachedId : attachments) {
                    Permanent attachedPerm = game.getPermanent(attachedId);
                    if (attachedPerm == null || !filter.match((Object)attachedPerm, game)) continue;
                    controller.moveCards((Card)attachedPerm, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.AURA.getPredicate());
    }
}

