/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScavengingOozeEffect
extends OneShotEffect {
    ScavengingOozeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target card from a graveyard. If it was a creature card, put a +1/+1 counter on {this} and you gain 1 life";
    }

    private ScavengingOozeEffect(ScavengingOozeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScavengingOozeEffect copy() {
        return new ScavengingOozeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && card != null) {
            controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
            if (card.isCreature(game)) {
                Permanent sourcePermanent = game.getPermanent(source.getSourceId());
                if (sourcePermanent != null) {
                    sourcePermanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                }
                controller.gainLife(1, game, source);
            }
            return true;
        }
        return false;
    }
}

