/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInHand;

class ScentOfCinderEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("any number of red cards in your hand");

    public ScentOfCinderEffect() {
        super(Outcome.Damage);
        this.staticText = "reveal any number of red cards in your hand. {this} deals X damage to any target, where X is the number of cards revealed this way";
    }

    private ScentOfCinderEffect(ScentOfCinderEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScentOfCinderEffect copy() {
        return new ScentOfCinderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = new RevealTargetFromHandCost(new TargetCardInHand(0, Integer.MAX_VALUE, filter));
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        int xValue = cost.getNumberRevealedCards();
        return new DamageTargetEffect(xValue).apply(game, source);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

