/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInHand;

class ScentOfJasmineEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("any number of white cards");

    public ScentOfJasmineEffect() {
        super(Outcome.GainLife);
        this.staticText = "reveal any number of white cards in your hand. You gain 2 life for each card revealed this way";
    }

    private ScentOfJasmineEffect(ScentOfJasmineEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScentOfJasmineEffect copy() {
        return new ScentOfJasmineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = new RevealTargetFromHandCost(new TargetCardInHand(0, Integer.MAX_VALUE, filter));
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        int xValue = cost.getNumberRevealedCards();
        return new GainLifeEffect(2 * xValue).apply(game, source);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

