/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ScepterOfEmpiresEffect
extends OneShotEffect {
    ScepterOfEmpiresEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "{this} deals 1 damage to target player or planeswalker. It deals 3 damage instead if you control artifacts named Crown of Empires and Throne of Empires";
    }

    private ScepterOfEmpiresEffect(ScepterOfEmpiresEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean throne = false;
        boolean crown = false;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (permanent.getName().equals("Throne of Empires")) {
                throne = true;
            } else if (permanent.getName().equals("Crown of Empires")) {
                crown = true;
            }
            if (!throne || !crown) continue;
            break;
        }
        int amount = throne && crown ? 3 : 1;
        return game.damagePlayerOrPermanent(source.getFirstTarget(), amount, source.getSourceId(), source, game, false, true) > 0;
    }

    public ScepterOfEmpiresEffect copy() {
        return new ScepterOfEmpiresEffect(this);
    }
}

