/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;
import mage.util.CardUtil;

class SchemingFenceChooseEffect
extends OneShotEffect {
    SchemingFenceChooseEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "you may choose a nonland permanent";
    }

    private SchemingFenceChooseEffect(SchemingFenceChooseEffect effect) {
        super((OneShotEffect)effect);
    }

    public SchemingFenceChooseEffect copy() {
        return new SchemingFenceChooseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent schemingFencePermanent = game.getPermanentEntering(source.getSourceId());
        if (controller == null || schemingFencePermanent == null) {
            return false;
        }
        TargetNonlandPermanent target = new TargetNonlandPermanent(0, 1, true);
        controller.choose(this.outcome, (Target)target, source, game);
        Permanent chosenPermanent = game.getPermanent(target.getFirstTarget());
        if (chosenPermanent == null) {
            return true;
        }
        game.getState().setValue(schemingFencePermanent.getId() + "_chosenPermanent", (Object)new MageObjectReference((MageObject)chosenPermanent, game));
        schemingFencePermanent.addInfo("chosen permanent", CardUtil.addToolTipMarkTags((String)("Chosen permanent: " + chosenPermanent.getIdName())), game);
        return true;
    }
}

