/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.common.CardsDrawnThisTurnWatcher;

class ScionOfHalasterReplacementEffect
extends ReplacementEffectImpl {
    ScionOfHalasterReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "The first time you would draw a card each turn, instead look at the top two cards of your library. Put one of them into your graveyard and the other back on top of your library. Then draw a card";
    }

    ScionOfHalasterReplacementEffect(ScionOfHalasterReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ScionOfHalasterReplacementEffect copy() {
        return new ScionOfHalasterReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        new LookLibraryAndPickControllerEffect(2, 1, PutCards.GRAVEYARD, PutCards.TOP_ANY).apply(game, source);
        Player you = game.getPlayer(event.getPlayerId());
        if (you != null) {
            you.drawCards(1, source, game, event);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        CardsDrawnThisTurnWatcher watcher = (CardsDrawnThisTurnWatcher)game.getState().getWatcher(CardsDrawnThisTurnWatcher.class);
        return watcher != null && watcher.getCardsDrawnThisTurn(event.getPlayerId()) == 0;
    }
}

