/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.BirdToken;
import mage.players.Player;

class ScourTheDesertEffect
extends OneShotEffect {
    ScourTheDesertEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from your graveyard. Create X 1/1 white Bird creature tokens with flying, where X is the exiled card's toughness";
    }

    private ScourTheDesertEffect(ScourTheDesertEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScourTheDesertEffect copy() {
        return new ScourTheDesertEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        int toughness = card.getToughness().getValue();
        player.moveCards(card, Zone.EXILED, source, game);
        if (toughness > 0) {
            new BirdToken().putOntoBattlefield(toughness, game, source, source.getControllerId());
        }
        return true;
    }
}

