/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScourgeOfFleetsEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("number of Islands you control");

    public ScourgeOfFleetsEffect() {
        super(Outcome.Benefit);
        this.staticText = "return each creature your opponents control with toughness X or less to its owner's hand, where X is the number of Islands you control";
    }

    private ScourgeOfFleetsEffect(ScourgeOfFleetsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScourgeOfFleetsEffect copy() {
        return new ScourgeOfFleetsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int islands = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
            FilterCreaturePermanent creatureFilter = new FilterCreaturePermanent();
            creatureFilter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
            creatureFilter.add((Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, islands + 1));
            CardsImpl cardsToHand = new CardsImpl();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)creatureFilter, source.getControllerId(), source, game)) {
                cardsToHand.add((Card)permanent);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

