/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ScourgeOfNelTothPlayEffect
extends AsThoughEffectImpl {
    ScourgeOfNelTothPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "You may cast {this} from your graveyard by paying {B}{B} and sacrificing two creatures rather than paying its mana cost";
    }

    private ScourgeOfNelTothPlayEffect(ScourgeOfNelTothPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ScourgeOfNelTothPlayEffect copy() {
        return new ScourgeOfNelTothPlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player player;
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (player = game.getPlayer(affectedControllerId)) != null) {
            CostsImpl costs = new CostsImpl();
            costs.add((Object)new SacrificeTargetCost(2, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES));
            player.setCastSourceIdWithAlternateMana(sourceId, (ManaCosts)new ManaCostsImpl("{B}{B}"), (Costs)costs, MageIdentifier.ScourgeOfNelTothAlternateCast);
            return true;
        }
        return false;
    }
}

