/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScourgeOfValkasDamageEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.DRAGON, "");

    ScourgeOfValkasDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals X damage to any target, where X is the number of Dragons you control";
    }

    private ScourgeOfValkasDamageEffect(ScourgeOfValkasDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScourgeOfValkasDamageEffect copy() {
        return new ScourgeOfValkasDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enteringDragon = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (controller == null || enteringDragon == null) {
            return false;
        }
        int dragons = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (dragons < 1) {
            return true;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            permanent.damage(dragons, enteringDragon.getId(), source, game, false, true);
        } else {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                player.damage(dragons, enteringDragon.getId(), source, game);
            }
        }
        return true;
    }
}

