/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class ScrapheapTriggeredAbility
extends TriggeredAbilityImpl {
    public ScrapheapTriggeredAbility copy() {
        return new ScrapheapTriggeredAbility(this);
    }

    public ScrapheapTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ScrapheapTriggeredAbility(ScrapheapTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && permanent.isOwnedBy(this.getControllerId()) && StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT.match(permanent, this.controllerId, (Ability)this, game);
    }

    public String getRule() {
        return "Whenever an artifact or enchantment is put into your graveyard from the battlefield, you gain 1 life.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

