/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ScribNibblersEffect
extends OneShotEffect {
    ScribNibblersEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exile the top card of target player's library. If it's a land card, you gain 1 life";
    }

    private ScribNibblersEffect(ScribNibblersEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScribNibblersEffect copy() {
        return new ScribNibblersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (you == null || targetPlayer == null || !targetPlayer.getLibrary().hasCards()) {
            return false;
        }
        Card card = targetPlayer.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        you.moveCards(card, Zone.EXILED, source, game);
        if (card.isLand(game)) {
            you.gainLife(1, game, source);
        }
        return true;
    }
}

