/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ScroungeEffect
extends OneShotEffect {
    ScroungeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent chooses an artifact card in their graveyard. Put that card onto the battlefield under your control";
    }

    private ScroungeEffect(ScroungeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScroungeEffect copy() {
        return new ScroungeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && opponent != null) {
            FilterArtifactCard filter = new FilterArtifactCard();
            filter.add((Predicate)new OwnerIdPredicate(opponent.getId()));
            TargetCardInGraveyard chosenCard = new TargetCardInGraveyard((FilterCard)filter);
            chosenCard.withNotTarget(true);
            if (chosenCard.canChoose(opponent.getId(), source, game)) {
                opponent.chooseTarget(Outcome.ReturnToHand, (Target)chosenCard, source, game);
                Card card = game.getCard(chosenCard.getFirstTarget());
                if (card != null) {
                    game.informPlayers("Scrounge: " + opponent.getLogName() + " has chosen " + card.getLogName());
                    CardsImpl cardsToMove = new CardsImpl();
                    cardsToMove.add(card);
                    controller.moveCards((Cards)cardsToMove, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

