/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.AbilityResolvedWatcher;

class ScythecatCubEffect
extends OneShotEffect {
    ScythecatCubEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on target creature you control. If this is the second time this ability has resolved this turn, double the number of +1/+1 counters on that creature instead";
    }

    private ScythecatCubEffect(ScythecatCubEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScythecatCubEffect copy() {
        return new ScythecatCubEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int count = AbilityResolvedWatcher.getResolutionCount((Game)game, (Ability)source) == 2 ? permanent.getCounters(game).getCount(CounterType.P1P1) : 1;
        return count > 0 && permanent.addCounters(CounterType.P1P1.createInstance(count), source, game);
    }
}

