/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SealOfTheGuildpactChooseColorEffect
extends OneShotEffect {
    SealOfTheGuildpactChooseColorEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose two colors";
    }

    private SealOfTheGuildpactChooseColorEffect(SealOfTheGuildpactChooseColorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SealOfTheGuildpactChooseColorEffect copy() {
        return new SealOfTheGuildpactChooseColorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        ChoiceColor choice1 = new ChoiceColor();
        if (controller != null && mageObject != null && controller.choose(Outcome.Benefit, (Choice)choice1, game)) {
            String color1 = choice1.getChoice();
            HashSet<String> choices2 = new HashSet<String>();
            if (!color1.equals("White")) {
                choices2.add("White");
            }
            if (!color1.equals("Blue")) {
                choices2.add("Blue");
            }
            if (!color1.equals("Black")) {
                choices2.add("Black");
            }
            if (!color1.equals("Red")) {
                choices2.add("Red");
            }
            if (!color1.equals("Green")) {
                choices2.add("Green");
            }
            ChoiceColor choice2 = new ChoiceColor();
            choice2.setChoices(choices2);
            if (!controller.choose(Outcome.Benefit, (Choice)choice2, game)) {
                return false;
            }
            String color2 = choice2.getChoice();
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + color1 + " and " + color2 + '.');
            }
            game.getState().setValue(mageObject.getId() + "_color1", (Object)choice1.getColor());
            game.getState().setValue(mageObject.getId() + "_color2", (Object)choice2.getColor());
            ((Card)mageObject).addInfo("chosen colors", CardUtil.addToolTipMarkTags((String)("Chosen colors: " + color1 + " and " + color2)), game);
            return true;
        }
        return false;
    }
}

