/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SearchTheCityExileEffect
extends OneShotEffect {
    SearchTheCityExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile the top five cards of your library";
    }

    private SearchTheCityExileEffect(SearchTheCityExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (int i = 0; i < 5; ++i) {
                if (!player.getLibrary().hasCards()) continue;
                Card topCard = player.getLibrary().getFromTop(game);
                topCard.moveToExile(source.getSourceId(), "Cards exiled by Search the City", source, game);
            }
            return true;
        }
        return false;
    }

    public SearchTheCityExileEffect copy() {
        return new SearchTheCityExileEffect(this);
    }
}

