/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.util.CardUtil;

class SearchTheCityExiledCardToHandEffect
extends OneShotEffect {
    SearchTheCityExiledCardToHandEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may put one of those cards with that name into its owner's hand. Then if there are no cards exiled with {this}, sacrifice it. If you do, take an extra turn after this one";
    }

    private SearchTheCityExiledCardToHandEffect(SearchTheCityExiledCardToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        String cardName = (String)this.getValue("cardName");
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ExileZone searchTheCityExileZone = game.getExile().getExileZone(source.getSourceId());
        if (cardName != null && searchTheCityExileZone != null) {
            for (Card card : searchTheCityExileZone.getCards(game)) {
                Permanent permanent;
                if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                if (controller.moveCards(card, Zone.HAND, source, game)) {
                    game.informPlayers("Search the City: put " + card.getName() + " into owner's hand");
                }
                searchTheCityExileZone.remove(card);
                if (searchTheCityExileZone.isEmpty() && (permanent = game.getPermanent(source.getSourceId())) != null) {
                    permanent.sacrifice(source, game);
                    game.getState().getTurnMods().add(new TurnMod(source.getControllerId()).withExtraTurn());
                }
                return true;
            }
        }
        return false;
    }

    public SearchTheCityExiledCardToHandEffect copy() {
        return new SearchTheCityExiledCardToHandEffect(this);
    }
}

