/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.RandomUtil;

class SeasonsBeatingsEffect
extends OneShotEffect {
    SeasonsBeatingsEffect() {
        super(Outcome.Damage);
        this.staticText = "Each creature target player controls deals damage equal to its power to another random creature that player controls";
    }

    private SeasonsBeatingsEffect(SeasonsBeatingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            HashMap<Integer, UUID> creatures = new HashMap<Integer, UUID>();
            int numCreature = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
                if (permanent == null) continue;
                creatures.put(numCreature, permanent.getId());
                ++numCreature;
            }
            if (numCreature < 2) {
                return true;
            }
            for (Integer i : creatures.keySet()) {
                Permanent creature = game.getPermanent((UUID)creatures.get(i));
                int other = RandomUtil.nextInt((int)numCreature);
                while (other == i) {
                    other = RandomUtil.nextInt((int)numCreature);
                }
                Permanent creature2 = game.getPermanent((UUID)creatures.get(other));
                if (creature == null || creature2 == null) continue;
                creature2.damage(creature.getPower().getValue(), creature.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    public SeasonsBeatingsEffect copy() {
        return new SeasonsBeatingsEffect(this);
    }
}

