/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class SeeBeyondEffect
extends OneShotEffect {
    SeeBeyondEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw two cards, then shuffle a card from your hand into your library";
    }

    private SeeBeyondEffect(SeeBeyondEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(2, source, game);
            if (!controller.getHand().isEmpty()) {
                TargetCard target = new TargetCard(Zone.HAND, new FilterCard("card to shuffle into your library"));
                controller.choose(Outcome.Detriment, controller.getHand(), target, source, game);
                Card card = controller.getHand().get(target.getFirstTarget(), game);
                if (card != null) {
                    controller.moveCards(card, Zone.LIBRARY, source, game);
                    controller.shuffleLibrary(source, game);
                }
                return true;
            }
        }
        return true;
    }

    public SeeBeyondEffect copy() {
        return new SeeBeyondEffect(this);
    }
}

