/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.AttachedToPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class SeedlingCharm
extends CardImpl {
    private static final FilterPermanent filter1 = new FilterPermanent("Aura attached to a creature");
    private static final FilterCreaturePermanent filter2 = new FilterCreaturePermanent("green creature");

    public SeedlingCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{G}");
        this.getSpellAbility().addEffect((Effect)new ReturnToHandTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter1));
        Mode mode = new Mode((Effect)new RegenerateTargetEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filter2));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn));
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addMode(mode);
    }

    private SeedlingCharm(SeedlingCharm card) {
        super((CardImpl)card);
    }

    public SeedlingCharm copy() {
        return new SeedlingCharm(this);
    }

    static {
        filter1.add((Predicate)SubType.AURA.getPredicate());
        filter1.add((ObjectSourcePlayerPredicate)new AttachedToPredicate((FilterPermanent)new FilterCreaturePermanent()));
        filter2.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
    }
}

