/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.SurveilEffect;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class SeerOfStolenSightTriggeredAbility
extends TriggeredAbilityImpl {
    SeerOfStolenSightTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SurveilEffect(1));
        this.setTriggerPhrase("Whenever one or more artifacts and/or creatures you control are put into a graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SeerOfStolenSightTriggeredAbility(SeerOfStolenSightTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SeerOfStolenSightTriggeredAbility copy() {
        return new SeerOfStolenSightTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (!zEvent.getToZone().match(Zone.GRAVEYARD)) return false;
        if (!zEvent.getFromZone().match(Zone.BATTLEFIELD)) return false;
        if (!zEvent.getCards().stream().filter(Objects::nonNull).map(MageItem::getId).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isArtifact(game) || permanent.isCreature(game)).map(Controllable::getControllerId).anyMatch(arg_0 -> ((SeerOfStolenSightTriggeredAbility)this).isControlledBy(arg_0))) return false;
        return true;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

