/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;

class SeismicWaveEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public SeismicWaveEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to any target and 1 damage to each nonartifact creature target opponent controls";
    }

    private SeismicWaveEffect(SeismicWaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeismicWaveEffect copy() {
        return new SeismicWaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Target targetOpponent;
        UUID opponentId;
        Targets targets = source.getTargets();
        if (targets.size() < 2) {
            return false;
        }
        UUID firstTarget = ((Target)targets.get(0)).getFirstTarget();
        if (firstTarget != null) {
            Permanent targetPermanent = game.getPermanent(firstTarget);
            if (targetPermanent != null) {
                targetPermanent.damage(2, source, game);
            } else {
                Player targetPlayer = game.getPlayer(firstTarget);
                if (targetPlayer != null) {
                    targetPlayer.damage(2, source, game);
                }
            }
        }
        if ((opponentId = (targetOpponent = (Target)targets.get(1)).getFirstTarget()) != null && targetOpponent.isLegal(source, game)) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, opponentId, game)) {
                permanent.damage(1, source, game);
            }
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.ARTIFACT.getPredicate()));
    }
}

