/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.FlashbackAbility;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

enum SeizeTheStormValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player == null) {
            return 0;
        }
        return player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game) + game.getExile().getCardsOwned(game, sourceAbility.getControllerId()).stream().filter(card -> card.getAbilities(game).containsClass(FlashbackAbility.class)).mapToInt(x -> 1).sum();
    }

    public SeizeTheStormValue copy() {
        return this;
    }

    public String getMessage() {
        return "instant and sorcery cards in your graveyard plus the number of cards with flashback you own in exile";
    }
}

