/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SpiritToken;
import mage.game.permanent.token.Token;

class SekkiSeasonsGuideEffect
extends PreventionEffectImpl {
    SekkiSeasonsGuideEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If damage would be dealt to {this}, prevent that damage, remove that many +1/+1 counters from {this}, and create that many 1/1 colorless Spirit creature tokens";
    }

    private SekkiSeasonsGuideEffect(SekkiSeasonsGuideEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public SekkiSeasonsGuideEffect copy() {
        return new SekkiSeasonsGuideEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        this.preventDamageAction(event, source, game);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.removeCounters(CounterType.P1P1.createInstance(damage), source, game);
        }
        new CreateTokenEffect((Token)new SpiritToken(), damage).apply(game, source);
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId());
    }
}

