/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class SenatorLottDodSpellsTargetingCreatureCostModificationEffect
extends CostModificationEffectImpl {
    SenatorLottDodSpellsTargetingCreatureCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Spell your opponents cast that target a creature you control cost {1} more to cast";
    }

    protected SenatorLottDodSpellsTargetingCreatureCostModificationEffect(SenatorLottDodSpellsTargetingCreatureCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set allTargets;
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return false;
        }
        Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
        if (spell != null) {
            allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        } else {
            allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
            if (allTargets.stream().anyMatch(target -> !this.isTargetCompatible((UUID)target, source, game))) {
                return false;
            }
        }
        return allTargets.stream().anyMatch(target -> this.isTargetCompatible((UUID)target, source, game));
    }

    private boolean isTargetCompatible(UUID target, Ability source, Game game) {
        Permanent targetPermanent = game.getPermanent(target);
        return targetPermanent != null && targetPermanent.isCreature(game) && targetPermanent.isControlledBy(source.getControllerId());
    }

    public SenatorLottDodSpellsTargetingCreatureCostModificationEffect copy() {
        return new SenatorLottDodSpellsTargetingCreatureCostModificationEffect(this);
    }
}

