/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPermanentAmount;

class SensationalSpiderManEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("permanents with stun counters on them");

    SensationalSpiderManEffect() {
        super(Outcome.Benefit);
        this.staticText = "then you may remove up to three stun counters from among all permanents. Draw cards equal to the number of stun counters removed this way";
    }

    private SensationalSpiderManEffect(SensationalSpiderManEffect effect) {
        super((OneShotEffect)effect);
    }

    public SensationalSpiderManEffect copy() {
        return new SensationalSpiderManEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanentAmount target = new TargetPermanentAmount(3, 0, filter);
        target.withNotTarget(true);
        player.chooseTarget(this.outcome, (Target)target, source, game);
        int amountRemoved = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).mapToInt(permanent -> permanent.removeCounters(CounterType.STUN.createInstance(target.getTargetAmount(permanent.getId())), source, game)).sum();
        if (amountRemoved > 1) {
            player.drawCards(amountRemoved, source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CounterType.STUN.getPredicate());
    }
}

