/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SenuKeenEyedProtectorEffect
extends OneShotEffect {
    SenuKeenEyedProtectorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put it onto the battlefield attacking";
    }

    private SenuKeenEyedProtectorEffect(SenuKeenEyedProtectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SenuKeenEyedProtectorEffect copy() {
        return new SenuKeenEyedProtectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent creature = game.getPermanent(card.getId());
        if (creature != null) {
            game.getCombat().addAttackingCreature(creature.getId(), game);
        }
        return true;
    }
}

