/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.command.emblems.SephirothOneWingedAngelEmblem;
import mage.game.events.GameEvent;

class SephirothOneWingedAngelEmblemEffect
extends ReplacementEffectImpl {
    SephirothOneWingedAngelEmblemEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as this creature transforms into {this}, you get an emblem with \"Whenever a creature dies, target opponent loses 1 life and you gain 1 life.\"";
    }

    private SephirothOneWingedAngelEmblemEffect(SephirothOneWingedAngelEmblemEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SephirothOneWingedAngelEmblemEffect copy() {
        return new SephirothOneWingedAngelEmblemEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Optional.ofNullable(source.getSourceObject(game)).ifPresent(obj -> game.addEmblem((Emblem)new SephirothOneWingedAngelEmblem(), obj, source));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMING;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId()) && source.getSourcePermanentIfItStillExists(game) != null;
    }
}

