/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SephirothOneWingedAngelSacrificeEffect
extends OneShotEffect {
    SephirothOneWingedAngelSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice any number of other creatures. If you do, draw that many cards";
    }

    private SephirothOneWingedAngelSacrificeEffect(SephirothOneWingedAngelSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SephirothOneWingedAngelSacrificeEffect copy() {
        return new SephirothOneWingedAngelSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE);
        player.choose(this.outcome, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++count;
        }
        if (count < 1) {
            return false;
        }
        player.drawCards(count, source, game);
        return true;
    }
}

