/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;

class SepulchralPrimordialEffect
extends OneShotEffect {
    SepulchralPrimordialEffect() {
        super(Outcome.GainControl);
        this.staticText = "for each opponent, you may put up to one target creature card from that player's graveyard onto the battlefield under your control";
    }

    private SepulchralPrimordialEffect(SepulchralPrimordialEffect effect) {
        super((OneShotEffect)effect);
    }

    public SepulchralPrimordialEffect copy() {
        return new SepulchralPrimordialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> cardsToBattlefield = new HashSet<Card>();
            for (Target target : source.getTargets()) {
                Card targetCard;
                if (!(target instanceof TargetCardInOpponentsGraveyard) || (targetCard = game.getCard(target.getFirstTarget())) == null) continue;
                cardsToBattlefield.add(targetCard);
            }
            if (!cardsToBattlefield.isEmpty()) {
                controller.moveCards(cardsToBattlefield, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

