/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.abilities.effects.common.cost.SpellsCostReductionControllerEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueConditionHint;
import mage.abilities.keyword.TransformAbility;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.c.CrystallizedSerah;
import mage.cards.s.SerahFarronPredicate;
import mage.cards.s.SerahFarronWatcher;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;

public final class SerahFarron
extends CardImpl {
    private static final FilterCard filter = new FilterCreatureCard("the first legendary creature spell you cast each turn");
    private static final FilterPermanent filter2 = new FilterControlledCreaturePermanent("you control two or more other legendary creatures");
    private static final Condition condition;
    private static final Hint hint;

    public SerahFarron(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.CITIZEN);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.secondSideCardClazz = CrystallizedSerah.class;
        this.addAbility(SerahFarron.makeAbility(), new SerahFarronWatcher());
        this.addAbility((Ability)new TransformAbility());
        this.addAbility(new BeginningOfCombatTriggeredAbility((Effect)new TransformSourceEffect(), true).withInterveningIf(condition).addHint(hint));
    }

    private SerahFarron(SerahFarron card) {
        super((CardImpl)card);
    }

    public SerahFarron copy() {
        return new SerahFarron(this);
    }

    public static Ability makeAbility() {
        return new SimpleStaticAbility((Effect)new SpellsCostReductionControllerEffect(filter, 2));
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)SerahFarronPredicate.instance);
        filter2.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter2.add((Predicate)SuperType.LEGENDARY.getPredicate());
        condition = new PermanentsOnTheBattlefieldCondition(filter2);
        hint = new ValueConditionHint("You control two or more other legendary creatures", (DynamicValue)new PermanentsOnBattlefieldCount(filter2), condition);
    }
}

