/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SerahFarronWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    public SerahFarronWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.isCreature(game) && spell.isLegendary(game)) {
            this.set.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return ((SerahFarronWatcher)game.getState().getWatcher(SerahFarronWatcher.class)).set.contains(playerId);
    }
}

