/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SerendibDjinnEffect
extends OneShotEffect {
    SerendibDjinnEffect() {
        super(Outcome.Damage);
        this.staticText = "sacrifice a land. If you sacrifice an Island this way, {this} deals 3 damage to you";
    }

    private SerendibDjinnEffect(SerendibDjinnEffect effect) {
        super((OneShotEffect)effect);
    }

    public SerendibDjinnEffect copy() {
        return new SerendibDjinnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
            if (target.canChoose(controller.getId(), source, game)) {
                controller.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                if (permanent != null) {
                    permanent.sacrifice(source, game);
                    if (permanent.hasSubtype(SubType.ISLAND, game)) {
                        controller.damage(3, source.getSourceId(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

