/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;

class SereneSleuthEffect
extends ContinuousEffectImpl {
    private MageObjectReference sourceMor;
    private final FilterPermanent filter;

    public SereneSleuthEffect(FilterPermanent filter) {
        super(Duration.Custom, Layer.RulesEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = "each creature you control is no longer goaded";
        this.filter = filter;
    }

    private SereneSleuthEffect(SereneSleuthEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.sourceMor = effect.sourceMor;
        this.filter = effect.filter;
    }

    public SereneSleuthEffect copy() {
        return new SereneSleuthEffect(this);
    }

    public MageObjectReference getSourceMor() {
        return this.sourceMor;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (ContinuousEffect effect : game.getContinuousEffects().getLayeredEffects(game)) {
            MageObjectReference effectsMor;
            if (!(effect instanceof SereneSleuthEffect) || (effectsMor = ((SereneSleuthEffect)effect).getSourceMor()) == null || !effectsMor.refersTo(source.getSourceId(), game)) continue;
            effect.discard();
            this.affectedObjectList.addAll(effect.getAffectedObjects());
        }
        this.sourceMor = new MageObjectReference(source.getSourceObject(game), game);
        this.setAffectedObjectsSet(true);
        game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game).stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(mor -> {
            if (!this.affectedObjectList.contains(mor)) {
                this.affectedObjectList.add(mor);
            }
        });
    }

    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            this.affectedObjectList.removeIf(mor -> !mor.zoneCounterIsCurrent(game) || mor.getPermanent(game) == null);
            if (this.affectedObjectList.isEmpty()) {
                this.discard();
                return false;
            }
            for (MageObjectReference mor2 : this.affectedObjectList) {
                mor2.getPermanent(game).getGoadingPlayers().clear();
            }
            return true;
        }
        return true;
    }
}

