/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.s.SerpentsSoulJarWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class SerpentsSoulJarCastFromExileEffect
extends AsThoughEffectImpl {
    SerpentsSoulJarCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, you may cast a creature spell from among cards exiled with {this}";
    }

    private SerpentsSoulJarCastFromExileEffect(SerpentsSoulJarCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SerpentsSoulJarCastFromExileEffect copy() {
        return new SerpentsSoulJarCastFromExileEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SerpentsSoulJarWatcher.addPlayable(source, game);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!SerpentsSoulJarWatcher.checkPermission(affectedControllerId, source, game)) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || !exileZone.contains((Object)sourceId)) {
            return false;
        }
        Card card = game.getCard(sourceId);
        return card != null && card.isCreature(game) && !card.isLand(game);
    }
}

