/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SerraAscendantEffect
extends ContinuousEffectImpl {
    SerraAscendantEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "As long as you have 30 or more life, {this} gets +5/+5 and has flying";
    }

    private SerraAscendantEffect(SerraAscendantEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SerraAscendantEffect copy() {
        return new SerraAscendantEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (creature != null && controller != null) {
            if (controller.getLife() >= 30) {
                switch (layer) {
                    case PTChangingEffects_7: {
                        if (sublayer != SubLayer.ModifyPT_7c) break;
                        creature.addPower(5);
                        creature.addToughness(5);
                        break;
                    }
                    case AbilityAddingRemovingEffects_6: {
                        if (sublayer != SubLayer.NA) break;
                        creature.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return Layer.AbilityAddingRemovingEffects_6 == layer || Layer.PTChangingEffects_7 == layer;
    }
}

