/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SerraParagonWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> map = new HashMap<MageObjectReference, Set<UUID>>();

    SerraParagonWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if ((event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED) && event.hasApprovingIdentifier(MageIdentifier.SerraParagonWatcher)) {
            this.map.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), x -> new HashSet()).add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((SerraParagonWatcher)game.getState().getWatcher(SerraParagonWatcher.class)).map.getOrDefault(new MageObjectReference(source.getSourceId(), game), Collections.emptySet()).contains(source.getControllerId());
    }
}

