/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SeshiroTheAnointedAbility
extends TriggeredAbilityImpl {
    public SeshiroTheAnointedAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
    }

    private SeshiroTheAnointedAbility(SeshiroTheAnointedAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SeshiroTheAnointedAbility copy() {
        return new SeshiroTheAnointedAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && p != null && p.hasSubtype(SubType.SNAKE, game) && p.isControlledBy(this.controllerId);
    }

    public String getRule() {
        return "Whenever a Snake you control deals combat damage to a player, you may draw a card.";
    }
}

