/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SeverTheBloodlineEffect
extends OneShotEffect {
    SeverTheBloodlineEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature and all other creatures with the same name as that creature";
    }

    private SeverTheBloodlineEffect(SeverTheBloodlineEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeverTheBloodlineEffect copy() {
        return new SeverTheBloodlineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPermanent != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
                filter.add((Predicate)new PermanentIdPredicate(targetPermanent.getId()));
            } else {
                filter.add((Predicate)new NamePredicate(targetPermanent.getName()));
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                controller.moveCardToExileWithInfo((Card)permanent, null, "", source, game, Zone.BATTLEFIELD, true);
            }
            return true;
        }
        return false;
    }
}

