/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class SevinnesReclamationEffect
extends OneShotEffect {
    SevinnesReclamationEffect() {
        super(Outcome.Benefit);
        this.staticText = "If this spell was cast from a graveyard, you may copy this spell and may choose a new target for the copy.";
    }

    private SevinnesReclamationEffect(SevinnesReclamationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SevinnesReclamationEffect copy() {
        return new SevinnesReclamationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(source.getSourceId(), false);
        Player player = game.getPlayer(source.getControllerId());
        if (spell == null || player == null) {
            return false;
        }
        if (spell.getFromZone() == Zone.GRAVEYARD && player.chooseUse(this.outcome, "Copy this spell?", source, game)) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        return true;
    }
}

