/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.ShadowOfTheEnemyCastFromExileEffect;
import mage.cards.s.ShadowOfTheEnemySpendManaEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShadowOfTheEnemyEffect
extends OneShotEffect {
    ShadowOfTheEnemyEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creature cards from target player's graveyard. You may cast spells from among those cards for as long as they remain exiled, and mana of any type can be spent to cast them.";
    }

    private ShadowOfTheEnemyEffect(ShadowOfTheEnemyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowOfTheEnemyEffect copy() {
        return new ShadowOfTheEnemyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (player == null || targetPlayer == null || sourceObject == null) {
            return false;
        }
        Set cards = targetPlayer.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        if (cards.isEmpty()) {
            return true;
        }
        player.moveCardsToExile(cards, source, game, true, source.getSourceId(), sourceObject.getName());
        for (Card card : cards) {
            AsThoughEffectImpl effect = new ShadowOfTheEnemyCastFromExileEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new ShadowOfTheEnemySpendManaEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

